/**
 * Copyright: Codetipi
 * Theme: Lets Review
 * Version: 3.4.3
 */
  /* global jQuery, letsReviewJS*/
(function( $ ) {
    'use strict';
	var letsReviewAdmin = {
		init: function() {
			this.cache();
			this.bind();
		},
		cache: function() {
			this.$item_reviewed = $('#lets-review__item-reviewed');
			this.$schema_wrap = $('#lets-review-schema__wrap');
			this.$schema_prop_title = $('#schema-properties');
		},
		bind: function() {
			this.$item_reviewed.on( 'change', this.itemReviewed );
		},
		itemReviewed: function() {
			var _this = $(this),
				val = _this.val(),
				options = letsReviewAdmin.$schema_wrap.find('.lets-review-schema');
				if ( val !== 'Movie' && val !== 'Product' ) {
					letsReviewAdmin.$schema_prop_title.addClass('lets-review-hidden');
				} else {
					letsReviewAdmin.$schema_prop_title.removeClass('lets-review-hidden');
				}
			options.each( function( index, el ) {
				if ( $(this).data('lr-req') === val || $(this).data('lr-req') === 'all' ) {
					$(this).removeClass('lets-review-hidden');
				} else {
					$(this).addClass('lets-review-hidden');
				}
			});
		}
	};

	letsReviewAdmin.init();

} )( jQuery );

/**
 * Copyright: Codetipi
 * Plugin: Lets Review
 * Version: 3.4.3
 */
(function( $ ) {
	'use strict';
	var letsReviewDebug = '',
		cbWindow = $( window ),
		cbDoc = $ ( document ),
		cbBody = $ ( 'body' ),
		cbAdminTabs = $('#cb-tabs'),
		cbAdminTabsA = cbAdminTabs.find('a'),
		cbTabContent = $('#cb-tab-content'),
		cbTabContentChildren = cbTabContent.children(),
		cbAdminWrap = $('.lets-review-wrap'),
		reviewSwitch = $('.lets-review-switch'),
		cbReviewWrap = $('#cb-review-wrap'),
		cbCrits = $( '#cb-criterias' ),
		cbSliderMax = cbCrits.data('cb-max'),
		cbSliderFormat = cbCrits.data('cb-format'),
		cbSliderStep = cbCrits.data('cb-step'),
		cbAffButtons = $('#cb-aff-buttons'),
		cbPros = $( '#cb-pros' ),
		cbCons = $( '#cb-cons' ),
		cbSliders = $( '.cb-review-slider' ),
		cbGalleryImgCont = $('#cb-gallery-cont'),
		finalScore = $('#cb-final-score'),
		finalScore100 = $('#cb-final-score-100'),
		finalScoreOverride = $('#cb-final-score-override'),
		cbGalleryImgContInput = cbGalleryImgCont.find('> input'),
		cbElement = $('.cb-element'),
		cbgalleryCounter = 0,
		cbCP = $('.lets-review-colorpicker'),
		cbCustomImgEl = $('#cb-custom-image-wrap'),
		cbCounter, cbThis, cbTabData, cbDataTrig, cbVar, cbAdminData, formatOld, total, formatNew, cbY, cbParent, cbData, sliderVal, cbGalleryImgs, cbImgUrl, cbOb, cbCritScores, cbMediaModal, cbSingleMediaModal, cbSingleImg, cbSingleImgD, cbSingleImgDInput, cbSingleImgName, cbRadioEl, cbTarget, sliderTarget;

	cbAdminTabsA.click( function(e) {
		e.preventDefault();
		cbThis = $(this);
		cbParent = cbThis.parent();

        if ( cbParent.hasClass('nav-tab-active') ) {

        	return;

        } else {

        	cbTabData = cbThis.data( 'cb-href' );

        	cbAdminTabs.find('.nav-tab-active').removeClass('nav-tab-active');
        	cbTabContentChildren.hide();
        	cbParent.addClass('nav-tab-active');
        	$('#' + cbTabData).show();

        }

    });

   var cbGDCheck = function( cbThis, cbType, cbVisiblity ) {

   		if ( letsReviewDebug === true ) {
   			console.log('cbGDCheck');
   		}

   		cbThis.each( function() {
   			cbRadioEl = $(this).closest('.cb-radio-images-element');
   			if ( ( cbType === 'load' ) && ( ! cbRadioEl.find('input').is(':checked') ) ) {
	   			return;
	   		}

			cbDataTrig = cbRadioEl.data('cb-trigger');
			cbAdminData = $(this).closest('.cb-trigger-wrap').data('cb-trigger');

			if ( typeof cbAdminData !== 'undefined' ) {

				if ( cbAdminData.indexOf(' ') >= 0 ){

					cbAdminData = '.' + cbAdminData.replace( ' ', ', .');
					cbVar = cbAdminWrap.find( cbAdminData );
					cbParent = cbVar.closest('tr');

				} else {
					cbVar = cbAdminWrap.find('.' + cbAdminData);

					cbParent = cbVar.closest('tr');
				}

				if ( cbDataTrig === 'cb-trig' ) {
					cbParent.addClass( cbVisiblity );
				} else {
					cbParent.removeClass( cbVisiblity );
				}

				if ( cbRadioEl.find('input').val() == 5 ) {
	   				cbCustomImgEl.closest('tr').addClass( cbVisiblity );
	   			} else {
	   				cbCustomImgEl.closest('tr').removeClass( cbVisiblity );
	   			}
			}
		});
   };

   	cbAdminWrap.on('click', '.cb-review-design > .cb-radio-images-element img', function( e ){
		cbGDCheck( $(this), 'click', 'cb-hidden-gd' );

	});

   	cbAdminWrap.on('click', '.cb-review-format > .cb-radio-images-element img', function( e ){
		cbGDCheck( $(this), 'click', 'cb-show-tr' );

	});

	$('#cb-custom-icon').add('#cb-custom-image-wrap').closest('tr').addClass('cb-hidden');

   cbGDCheck( cbAdminWrap.find('.cb-review-design > .cb-radio-images-element img'), 'load', 'cb-hidden-gd' );
   cbGDCheck( cbAdminWrap.find('.cb-review-format > .cb-radio-images-element img'), 'load', 'cb-show-tr', 5 );

	reviewSwitch.onoff();

	cbDoc.ready(function() {
		cbCP.wpColorPicker();
  	});

	reviewSwitch.click( function() {
		if ( letsReviewDebug === true ) {
			console.log('reviewSwitch Click');
		}
		var reviewSwitchCurrent = $(this);
		if ( reviewSwitchCurrent.hasClass('lets-review-main-switch') ) {
			if ( reviewSwitchCurrent.is(':checked') ) {
			    cbReviewWrap.slideDown('fast');
			} else {
			    cbReviewWrap.slideUp('fast');
			}
		}

		if ( reviewSwitchCurrent.hasClass('lets-review-main-title') ) {
			var reviewSwitchData = reviewSwitchCurrent.data();

			if ( reviewSwitchCurrent.is(':checked') ) {
			    $( '.' + reviewSwitchData['visible']).slideUp('fast');
			} else {
			    $( '.' +  reviewSwitchData['visible']).slideDown('fast');
			}
		}
		elementChecker( 200 );

	});
	elementChecker( 0 );
	function elementChecker( speed ) {
		cbElement.each( function() {
			var element = $(this);
			var elementClosest = element.closest('tr').children();
			var elementReq = element.data('required');

			if (  elementReq ) {
				if (  $( '#' + elementReq).is(":checked") === true ) {
					if ( element.data('required-val' ) === 'on' ) {
						elementClosest.slideDown( speed );
					} else {
						elementClosest.slideUp( speed );
					}
				} else {
					if ( element.data('required-val' ) === 'off' ) {
						elementClosest.slideDown( speed );
					} else {
						elementClosest.slideUp( speed );
					}
				}
			}
		});
	}

	cbSliders.each( function() {

		sliderVal = $(this).next().attr('value');

		sliderTarget = $(this).data('target');
		cbSliderMax = $( '#' + sliderTarget ).data('cb-max');
		cbSliderStep = $( '#' + sliderTarget ).data('cb-step');

		$(this).slider({
			min: 0,
			max: cbSliderMax,
			range: 'min',
			value: sliderVal,
			step: cbSliderStep,
		});

		if ( ! $('#lets-review-metabox').length ) {
			$(this).slider( "disable" );
		}

	});

	$('#wpbody .cb-main-wrap').on('click', '.cb-trigger-wrap > .cb-radio-images-element', function( e ){
		if ( letsReviewDebug === true ) {
			console.log('#wpbody .cb-main-wrap on click, cb-radio-images-element');
		}

		cbThis = $(this);
		cbParent = cbThis.parent();
		cbData = cbThis.data('cb-trigger');

		if ( typeof cbData !== 'undefined' ) {
			cbVar = $('#' + cbData);
			if ( ! cbVar.hasClass('cb-shower')  ) {
				cbParent.find('.cb-trigger-block:not(#' + cbData + ')').addClass('cb-hidden').slideUp(200);
				cbParent.children().removeClass('cb-shower');
				cbVar.addClass('cb-shower');
				cbVar.slideDown(200);
			}

		} else {
			cbParent.children().removeClass('cb-shower');
			cbParent.find('.cb-trigger-block').addClass('cb-hidden');
			cbParent.find('.cb-trigger-block').slideUp(200);
		}
	});

	$('#wpbody .cb-main-wrap').on('click', '.cb-trigger-wrap-slider > .cb-radio-images-element > label > img', function( e ){
		if ( letsReviewDebug === true ) {
			console.log('#wpbody .cb-main-wrap on click, finalScore');
		}

		cbY = $(this);
		formatNew = cbY.prev().val();
		cbSliderMax = 5;
		cbSliderStep = 0.1;
		sliderTarget = cbY.data('target');
		sliderTarget = $( '#' + sliderTarget );
		formatOld = sliderTarget.data('cb-format');
		sliderTarget.data('cb-format', 'cb-format-' + formatNew );
		cbSliderFormat = sliderTarget.data('cb-format');

		if ( typeof cbSliderFormat === 'undefined' ) {
			return;
		}

		if ( formatNew === '1' ) {
			cbSliderMax = 100;
			cbSliderStep = 1;
		} else if ( formatNew === '2'  ) {
			cbSliderMax = 10;
		}

		sliderTarget.data( 'cb-max', cbSliderMax );
		sliderTarget.data( 'cb-step', cbSliderStep );

		var avdada = sliderTarget.find('.cb-review-slider');
		if ( avdada.length > 0 ) {
			avdada.each(function() {
				sliderVal = $(this).slider( 'option', 'value' );
				sliderVal = convertScoreBetweenFormats( formatOld, formatNew, sliderVal );
				$(this).next().val( sliderVal );
				$(this).slider( 'option', { max: cbSliderMax, step: cbSliderStep, value: sliderVal  } );
			});
		} else {
			finalScore.val( convertScoreBetweenFormats( formatOld, formatNew, finalScore.val() ) );
		}
		if ( formatOld.slice(-1) === '1' ) {
			finalScore100.val( finalScore.val() );
		} else if ( formatOld.slice(-1) === '2' ) {
			finalScore100.val( finalScore.val() * 10 );
		} else {
			finalScore100.val( finalScore.val() * 20 );
		}

		scoreCalc( sliderTarget );

	});

	function convertScoreBetweenFormats( formatOld, formatNew, value ) {
		if ( formatOld.slice(-1) === '1' ) {
			if ( formatNew === '2' ) {
				value = ( value / 10 );
			} else if  ( formatNew !== '1' ) {
				value = Math.round( ( value / 20 ) * 10) / 10;
			}
		} else if ( formatOld.slice(-1) === '2' ) {
			if ( formatNew === '1' ) {
				value = ( value * 10 );
			} else if  ( formatNew !== '2' ) {
				value = Math.round( ( value / 2 ) * 10) / 10;
			}

		} else {
			if ( formatNew === '1' ) {
				value = ( value * 20 );
			} else if ( formatNew === '2' ) {
				value = ( value * 2 );
			}
		}
		return value;
	}

	cbDoc.on( 'input', finalScore, function() {
		if ( letsReviewDebug === true ) {
			console.log('on input, finalScore');
		}
		finalScore.prev().slider('value',  finalScore.val() );
	});


	cbDoc.on( 'slide', '.cb-review-slider', function( event, ui ) {
		if ( letsReviewDebug === true ) {
			console.log('On Slide');
		}

		$(this).next().val( ui.value );
		if ( $(this).hasClass('cb-exclude') ) {

			finalScoreOverride.val( finalScore.val() );
			formatOld = cbCrits.data('cb-format');
	    	if ( formatOld.slice(-1) === '1' ) {
				finalScore100.val( finalScore.val() );
			} else if ( formatOld.slice(-1) === '2' ) {
				finalScore100.val( finalScore.val() * 10 );
			} else {
				finalScore100.val( finalScore.val() * 20 );
			}
		} else {
			finalScoreOverride.val('off');
			scoreCalc();
		}

	});

	function scoreCalc( sliderTarget ) {
		if ( letsReviewDebug === true ) {
			console.log('scoreCalc');
		}

		if ( typeof cbSliderFormat === 'undefined' ) {
			return;
		}

        var criteriaTotal = 0;

        if ( typeof(sliderTarget) === 'undefined' ) {
        	sliderTarget = cbCrits;
        }

        cbCritScores = sliderTarget.find('.cb-cri-score');


        cbCritScores.each(function() {
            criteriaTotal += parseFloat( $(this).val() );
        });
		if ( cbCritScores.length > 1 ) {
			criteriaTotal = criteriaTotal / cbCritScores.length;
		}
		var format = cbSliderFormat.slice(-1);
        if ( criteriaTotal === 0 && finalScore.val() > 0 ) {
        	criteriaTotal = finalScore.val();
			console.log( "cbSliderFormat.slice(-1) => ", cbSliderFormat.slice(-1) );
			if ( format === '1' ) {
				total = Math.round( criteriaTotal );
			} else {
				if ( letsReview.doubleDecimalStars === 'on' ) {
					total = ( criteriaTotal ).toFixed(2);
				} else {
					total = Math.round( criteriaTotal * 10 ) / 10;
				}
			}
        } else {
			if ( format === '1' ) {
				total = Math.round( criteriaTotal );
			} else {
				if ( letsReview.doubleDecimalStars === 'on' ) {
					total = ( criteriaTotal ).toFixed(2);
				} else {
					total = Math.round( criteriaTotal * 10 ) / 10;
				}
			}
		}

        if ( isNaN(total) ) {
        	finalScore100.val('');
        	finalScore.val('');
        	finalScore.prev().slider( 'option', { max: cbSliderMax, step: cbSliderStep, value: finalScore.val() } );
    	} else {
    		if ( finalScoreOverride.hasClass('cb-ldd') || finalScoreOverride.val() === 'off' ) {
    			finalScore.val(total);
	    		finalScore.prev().slider( 'option', { max: cbSliderMax, step: cbSliderStep, value: total } );
	    		finalScoreOverride.val('off');
    		}

	    	formatOld = sliderTarget.data('cb-format');
	    	if ( formatOld.slice(-1) === '1' ) {
				finalScore100.val( finalScore.val() );
			} else if ( formatOld.slice(-1) === '2' ) {
				finalScore100.val( finalScore.val() * 10 );

			} else {
				finalScore100.val( finalScore.val() * 20 );
			}
	    }

    }

	cbCrits.add(cbPros).add(cbAffButtons).add(cbCons).add(cbGalleryImgCont).sortable({
	  	placeholder: 'ui-state-highlight',
		classes: {
			'ui-sortable': 'lets-review-control-only'
		}
	});

	cbBody.on( 'click', '.cb-add-criteria', function( e ) {
		e.preventDefault();

		cbCounter = $(this).data( 'cb-counter' );
		cbTarget = $(this).data( 'target' );

		cbData = '<li class="ui-state-default cb-list-field cb-criteria-field lr-cf cb-criteria-' + cbCounter + '"><div class="cb-criteria-title"><span class="cb-list-title">' + letsReview.cbTitle + '</span><input type="text" value="" name="lets_review_criterias[' + cbCounter + '][title]" class="cb-input cb-criteria-field-' + cbCounter + ' cb-crit-detect"></div><div class="cb-criteria-score lr-cf"><span class="cb-list-title">' + letsReview.cbScoreTitle + '</span><div class="cb-review-slider cb-slider" data-target="' + cbTarget + '"></div><input type="text" class="cb-cri-score cb-input cb-crit-detect" value="0" name="lets_review_criterias[' + cbCounter + '][score]" readonly></div><a href="#" class="cb-button cb-remove">&#xd7;</a></li>';
		$( '#' + cbTarget ).append( cbData );

		$( '#' + cbTarget ).find( '.cb-criteria-' + cbCounter + ' .cb-review-slider' ).each( function() {

			sliderTarget = $(this).data('target');
			cbSliderMax = $( '#' + sliderTarget ).data('cb-max');
			cbSliderStep = $( '#' + sliderTarget ).data('cb-step');

			$(this).slider({
				min: 0,
				range: 'min',
				max: cbSliderMax,
				step: cbSliderStep,
			});
		});

		if ( ! $('#lets-review-metabox').length ) {
			$( '#' + cbTarget ).find( '.cb-criteria-' + cbCounter + ' .cb-review-slider' ).slider( "disable" );
		}

		$('.cb-criteria-field-' + cbCounter).focus();
		cbCounter++;
		scoreCalc( $( '#' + cbTarget ) );
		$(this).data('cb-counter', cbCounter);

	});

	cbBody.on( 'click', '.cb-add-aff', function( e ) {
		e.preventDefault();

		cbCounter = $(this).data( 'cb-counter' );
		cbTarget = $(this).data( 'target' );
		cbData = '<li class="ui-state-default cb-list-field cb-affiliate-field lr-cf cb-aff-option-' + cbCounter + '"><div class="cb-aff-option-title cb-list-hw"><span class="cb-list-title">' + letsReview.cbTitle + '</span><input type="text" value="" name="lets_review_aff_buttons[' + cbCounter + '][title]"  class="cb-input cb-aff-option-field-' + cbCounter + ' cb-aff-detect"></div><div class="cb-aff-option-url cb-list-hw cb-list-hw-2"><div class="cb-list-title">' + letsReview.cbUrlTitle + '</div><input type="text" value="" name="lets_review_aff_buttons[' + cbCounter + '][url]"  class="cb-input cb-aff-option-field-' + cbCounter + ' cb-aff-detect"></div><a href="#" class="cb-button cb-remove">&#xd7;</a></li>';
		$( '#' + cbTarget ).append( cbData );
		$('.cb-aff-option-field-' + cbCounter).focus();
		cbCounter++;
		$(this).data('cb-counter', cbCounter);

	});

	cbBody.on( 'click', '.cb-add-pro', function( e ) {
		e.preventDefault();

		cbCounter = $(this).data( 'cb-counter' );
		cbTarget = $(this).data( 'target' );

		cbData = '<li class="ui-state-default cb-list-field cb-pro-' + cbCounter + '"><div class="cb-pro-title"><span class="cb-list-title">' + letsReview.cbTitle + '</span><input type="text" value="" name="lets_review_pros[' + cbCounter + '][positive]"  class="cb-input cb-pro-field-' + cbCounter + ' cb-pro-detect"></div><a href="#" class="cb-button cb-remove">&#xd7;</a></li>';
		$( '#' + cbTarget ).append( cbData );
		$('.cb-pro-field-' + cbCounter).focus();
		cbCounter++;
		$(this).data('cb-counter', cbCounter);

	});

	cbBody.on( 'click', '.cb-add-con', function( e ) {
		e.preventDefault();

		cbCounter = $(this).data( 'cb-counter' );
		cbTarget = $(this).data( 'target' );

		cbData = '<li class="ui-state-default cb-list-field cb-con-' + cbCounter + '"><div class="cb-con-title"><span class="cb-list-title">' + letsReview.cbTitle + '</span><input type="text" value="" name="lets_review_cons[' + cbCounter + '][negative]"  class="cb-input cb-con-field-' + cbCounter + ' cb-con-detect"></div><a href="#" class="cb-button cb-remove">&#xd7;</a></li>';
		$( '#' + cbTarget ).append( cbData );
		$('.cb-con-field-' + cbCounter).focus();
		cbCounter++;
		$(this).data('cb-counter', cbCounter);

	});

	cbBody.on('click', '.cb-remove', function( e ){
		e.preventDefault();
		$(this).parent().remove();
		scoreCalc();
	});

	cbWindow.load(function() {
		scoreCalc();
		finalScoreOverride.addClass('cb-ldd');
	});

	cbBody.on('click', '.cb-single-image-trigger', function( e ){

	 	e.preventDefault();
	 	cbThis = $(this);
	 	cbSingleImgD = $(this).data( 'cb-dest' );
	 	cbSingleImgName = $(this).data( 'cb-name' );
	 	cbSingleImgDInput = $('#' + cbSingleImgD).find('> input');

	 	if ( typeof cbSingleMediaModal !== 'undefined' ) {

			cbSingleMediaModal.open();
			return;

		}

		cbSingleMediaModal = wp.media({
			title:  letsReview.cbMediaSTitle,
			button: {

				text: letsReview.cbMediaButton,
			},
			multiple: false
		});

	    cbSingleMediaModal.on( 'select', function(){

        	cbSingleImg = cbSingleMediaModal.state().get('selection').first().toJSON();

			if ( typeof cbSingleImg.sizes.thumbnail !== 'undefined' ) {
				cbImgUrl = cbSingleImg.sizes.thumbnail.url;
			} else {
				cbImgUrl = cbSingleImg.url;
			}

             $('#' + cbSingleImgD).find('.cb-gallery-img').remove();
             $('#' + cbSingleImgD).append( '<span id="cb-img-' + cbSingleImg.id + '" data-cb-id="' + cbSingleImg.id + '" class="cb-gallery-img"><a href="#" class="cb-remove">&#xd7;</a><img src="' + cbImgUrl + '" alt=""><input type="hidden" value="' + cbSingleImg.id  + '" name="' + cbSingleImgName + '"></span>' );
            cbSingleImgDInput.val( cbSingleImg.id );

		});

		cbSingleMediaModal.open();

	});

	 cbBody.on('click', '.cb-gallery-trigger', function( e ){

	 	e.preventDefault();
	 	cbThis = $(this);
	 	cbCounter = $(this).data( 'cb-counter' );
	 	cbTarget = $(this).data( 'target' );

	 	if ( typeof cbMediaModal !== 'undefined' ) {

			cbMediaModal.open();
			return;

		}

		cbMediaModal = wp.media({
			title: letsReview.cbMediaTitle,
			button: {
				text: letsReview.cbMediaButton
			},
			multiple: true
		});

	    cbMediaModal.on( 'select', function(){

        	cbGalleryImgs = cbMediaModal.state().get("selection").models;

			for ( cbgalleryCounter; cbgalleryCounter < cbGalleryImgs.length; cbgalleryCounter++ ) {

				cbOb = cbGalleryImgs[cbgalleryCounter].toJSON();
				cbCounter++;

				if ( typeof cbOb.sizes.thumbnail !== undefined ) {
					cbImgUrl = cbOb.sizes.thumbnail.url;
				} else {
					cbImgUrl = cbOb.url;
				}

	            $( '#' + cbTarget ).append( '<span id="cb-img-' + cbOb.id + '" data-cb-id="' + cbOb.id + '" class="cb-gallery-img"><a href="#" class="cb-remove">&#xd7;</a><img src="' + cbImgUrl + '" alt=""><input type="hidden" value="' + cbOb.id  + '" class="cb-gallery-detect" name="lets_review_gallery_imgs[' + cbCounter + '][attachment-id]"></span>' );
	            cbGalleryImgContInput.val(function(i,val) {
				     return val + (!val ? '' : ', ') + cbOb.id;
				});

				cbThis.data('cb-counter', cbCounter);
	        }

	        cbgalleryCounter = 0;

		});

		cbMediaModal.open();

	 });


	 cbBody.on('change', '.lets-review-design-choice', function (e) {

	 	checkDesignChoices($(this));

    });

	 cbBody.on('change', '.lets-review-source-choice', function (e) {

	 	checkSourceChoices($(this));

    });

	 $( document ).on( 'widget-added widget-updated', function(event, widget) {
		var cbWidget = widget.find('.lets-review-design-choice');
        checkDesignChoices( cbWidget );

        var cbWidgetSource = widget.find('.lets-review-source-choice');
        checkSourceChoices( cbWidgetSource );

	});

	function checkSourceChoices( element ) {

		var sourceTags = element.closest('.widget-content').find('.source-tags');
	 	var sourceCats = element.closest('.widget-content').find('.source-cats');
	 	var sourcePosts = element.closest('.widget-content').find('.source-posts');
	 	var sourceCPT = element.closest('.widget-content').find('.source-cpt');

	 	if ( parseInt( element.val() ) === 1 ) {
	 		sourceTags.add(sourcePosts).add(sourceCPT).slideUp(200);
	 		sourceCats.slideDown(200);
	 	}

	 	if ( parseInt( element.val() ) === 2 ) {
	 		sourceCats.add(sourcePosts).add(sourceCPT).slideUp(200);
	 		sourceTags.slideDown(200);
	 	}

	 	if ( parseInt( element.val() ) === 3 ) {
	 		sourceTags.add(sourceCats).add(sourceCPT).slideUp(200);
	 		sourcePosts.slideDown(200);
	 	}

	 	if ( parseInt( element.val() ) === 4 ) {
	 		sourceTags.add(sourceCats).add(sourcePosts).slideUp(200);
	 		sourceCPT.slideDown(200);
	 	}

	}

	function checkDesignChoices( element ) {
	 	if ( parseInt( element.val() ) === 4 ) {
    		element.closest('p').next().slideDown(200);
    	} else {
    		element.closest('p').next().slideUp(200);
    	}
	}

})( jQuery );